#ifndef _ILogger_h__
#define _ILogger_h__

#include <GSTenums.h>
#include <buildspec.h>

#include <Utils/console.h>

#include <boost/lexical_cast.hpp>
#include <string>

namespace GST
{
namespace Utils
{

class GST_API_EXPORT ILogger
{
public:
	ILogger();

	virtual void printError(const std::string &msg) = 0;
	virtual void printWarning(const std::string &msg) = 0;
	virtual void printStatus(const std::string &msg) = 0;
	virtual void printDebug(const std::string &msg)
	{
		return this->printStatus("Debug: " + msg);
	}
	virtual void printNetworkPID(const long &pid, const std::string &sql)
	{
		return this->printStatus("PID: " + boost::lexical_cast<std::string>(pid)
								 + ", query = " + sql);
	}
	void setConsoleInstance(Console *console);

protected:
	static std::string GenerateMessage(LogLevel ltype, const std::string &msg);

	Console *getConsoleInstance();

private:
	/**
	 * Points to base class in order to have access to global console inside
	 * of a mutexed method. If you want to use this pointer in your ILogger
	 * class call setConsoleInstance( Console::getInstance() ) first to set
	 * this pointer.
	 */
	Console *m_console;
};

} // namespace Utils
} // namespace GST

#endif // _ILogger_h__
